﻿/* Copyright 2024, Kasyan Servetsky
October 10, 2024
Written by Kasyan Servetsky
http://www.kasyan.ho.ua
e-mail: askoldich@yahoo.com */
//=======================================================================================
#targetengine "FindDupes"
Reset();
var scriptName = "Find duplicate chars-words - 1.1",
gTmpFileName = scriptName.replace(/\s*\-\s*\d+\.\d+$/, "").replace(/\s+/g, "_").toLowerCase(),
gUrl = "http://kasyan.ho.ua/indesign/text/" + gTmpFileName + "/" + gTmpFileName + ".html", // URL to this script on my site
gTmpSubFolderName = "Kasyan",
debug = false,
log = false, // ============ Logging ============
logDebugFuncList = ["FindAll"], // list of the functions for logging
logDebugListOnly = false,
logOverwrite = true,
logFullCount = 0,
logErrCount = 0,
logErrOnly = false,
logHeaderAdded = false, // DON'T CHANGE - Header added to the full log
logErrArr = [], // ========= End logging =========
doc, w, gBtnFind, gInfo,
set = null,
f = 0, // global - used in IterateFinds & Reset
gDupes = [],
gFoundAll = false, // FindAll function was run
gWarningOverset = false, // warning about overset text was displayed
gInterruptMsgs = false, // interrupt furter messages
gStory = null,
gText = null,
gPuncMarksBegPatt = /^[¿¡•\s\(\[]/, // punctuation marks at the beginning of the line
gPuncMarksEndPatt = /[\s\.\?\)\],:;!-]/, // punctuation marks at the end of the line
gInitInfoMsg = "No duplicates were found so far.\rClick 'Find' to start searching them.";

CreateDialog();
//====================================== FUNCTIONS ======================================
function FindAll() {
	try {
		Log(">");
		if (debug) var startTime = new Date();
		
		CheckSelection();
		
		if (gInterruptMsgs) {
			return;
		}
		
		var lines, lineThis, txtThis, txtPrev, trimmedTxt,
		lineThisCont, linePrevCont, txtThisCont, txtPrevCont,
		linePrev = lineThis = null;
		
		var word_char = (set.ddlWordChar == 0) ? "words" : "characters";
		var beg_end = (set.ddlBegEnd == 0) ? "0" : "-1";
		Log("word_char = " + word_char);
		Log("beg_end = " + beg_end);
		Log("gStory.id = " + gStory.id);

		if (set.ddlStoryText == 0 && gStory != null) {
			Log("Story processed");
			lines = gStory.lines;
		}
		else if (set.ddlStoryText == 1 && gText != null) {
			Log("Selected text processed");
			lines = gText.lines;
		}
		else {
			Log("Can't get the gStory/text to process.", true);
			ErrorExit("Can't get the gStory/text to process.", true);
		}
	
		Log("---------------------------------");
		
		var progressWin = new Window("window", scriptName);
		var progressBar = progressWin.add("progressbar" , undefined, 0, lines.length);
		progressBar.preferredSize.width = 600;
		var progressTxt = progressWin.add("statictext", undefined, "");
		progressTxt.alignment = "fill";
		progressWin.show();
		
		//================================================================================================
		for (var i = 0; i < lines.length; i++) {
			lineThis = lines[i]; // THIS LINE
			lineThisCont = lineThis.contents;
			Log("\r---------------------------------------------------------------------------------------------------\r" + ZeroPad(i, 2) + " | " + ((lineThisCont.length == 1) ? "lineThisCont.length = 1 | lineThisCont.charCodeAt(0) = " + lineThisCont.charCodeAt(0) : "lineThisCont (raw):\r" + lineThisCont));

//~ 			if (debug) $.writeln(ZeroPad(i, 2) + " - " + lineThisCont);
//~ 			if (i == 4) debugger;
			
			countProgressBar = i + 1;
			progressBar.value = countProgressBar;
			progressTxt.text = "Scanning line " + countProgressBar  + " out of " +  lines.length;

			if (lineThisCont == "" || lineThisCont == "\r" || lineThisCont == "\n") continue;
			// Only words at the end of lines, otherwise it's a waste of time
			if (word_char == "words" && beg_end == -1) {
				hyphenatedLastWord = CheckHyphenated(lineThis);
				
				if (hyphenatedLastWord) { // hyphenatedLastWord word at the end of line
					Log("lineThis - the last word is hyphenated - skipping");
					continue;
				}
			}

			trimmedTxt = TrimLine(lineThis, beg_end);
			lineThis = trimmedTxt.txt;
			
			txtThis = eval("lineThis." + word_char + "[" + beg_end + "]");
			if (txtThis == null) continue;
			txtThisCont = txtThis.contents;
			if (txtThisCont.constructor.name == "Enumerator") continue;
			
			if (set.cbIgnorePunctuation && set.ddlWordChar == 0) { // A special case
				var allCharsTxtThis = txtThis.characters.everyItem().getElements();
				
				if (set.ddlBegEnd == 0 && // the1st word preceded with a punctuation mark
					txtThisCont.match(gPuncMarksBegPatt) != null &&
					trimmedTxt.firstCharIdx != null
				) {
					txtThis = gStory.characters.itemByRange(trimmedTxt.firstCharIdx, allCharsTxtThis[allCharsTxtThis.length - 1].index).getElements()[0];
				}
				else if (set.ddlBegEnd == 1 && // the last word followed by a punctuation mark
					txtThisCont.match(gPuncMarksEndPatt) != null &&
					trimmedTxt.lastCharIdx != null
				) {
					txtThis = gStory.characters.itemByRange(allCharsTxtThis[0].index, trimmedTxt.lastCharIdx).getElements()[0];
				}
			} // End - special case

			txtThisCont = CleanText(txtThisCont);
			Log("txtThisCont (cleaned) = " + txtThisCont);
			
			// Idea for the future: use lineThis for linePrev so that the calculation is made only once instead of twice 
			var linePrev = ((i > 0) ? lines[i - 1] : null); // PREVIOUS LINE
			if (linePrev == null) continue;
			linePrevCont = linePrev.contents;
			Log((linePrevCont.length == 1) ? "linePrevCont.length = 1 | linePrevCont.charCodeAt(0) = " + linePrevCont.charCodeAt(0) : "linePrevCont (raw):\r" + linePrevCont)
//~ 			Log("linePrevCont:\r" + linePrevCont);
			
			if (linePrevCont == "" || linePrevCont == "\r" || linePrevCont == "\n") continue;
			// Only words at the end of lines, otherwise it's a waste of time
			if (word_char == "words" && beg_end == -1) {
				hyphenatedLastWord = CheckHyphenated(linePrev);
				
				if (hyphenatedLastWord) { // hyphenatedLastWord word at the end of line
					Log("linePrev - the last word is hyphenated - skipping");
					continue;
				}
			}
		
			trimmedTxt = TrimLine(linePrev, beg_end);
			linePrev = trimmedTxt.txt;

			txtPrev = eval("linePrev." + word_char + "[" + beg_end + "]");
			if (txtPrev == null) continue;
			txtPrevCont = txtPrev.contents;
			if (txtPrevCont.constructor.name == "Enumerator") continue;
			txtPrevCont = CleanText(txtPrevCont); // remove special chars & spaces
						
			if (txtThisCont == txtPrevCont) {
				Log("txtThisCont = txtPrevCont | " + CharCodeString(txtThisCont));
				
				if (gDupes.length > 0) { // remove if the last characters are identical
					var lastEl = gDupes[gDupes.length - 1];
					if (lastEl.lines[0].index == txtPrev.lines[0].index) {
						Log("remove identical gDupes: lastEl.lines[0].index == txtPrev.lines[0].index -- " + lastEl.lines[0].index);
						gDupes.pop(); 
					}
				}
				
				Log("ADDING: " + txtThisCont + " = " + txtPrevCont);
				gDupes.push(txtThis);
			}
			else {
				Log("txtThisCont != txtPrevCont:\rCharCodeString(txtThisCont) = " + CharCodeString(txtThisCont) + " (" + txtThisCont + ")" + "\rCharCodeString(txtPrevCont) = " + CharCodeString(txtPrevCont) + " (" + txtPrevCont + ")");
				if (debug) {
//~ 					$.writeln("txtThisCont != txtPrevCont:\rCharCodeString(txtThisCont) = " + CharCodeString(txtThisCont) + " (" + txtThisCont + ")" + "\rCharCodeString(txtPrevCont) = " + CharCodeString(txtPrevCont) + " (" + txtPrevCont + ")");
					//debugger;
				}
			}
		} // end for lines
		//================================================================================================
		
		progressWin.close();

		if (gDupes.length == 0) {
			gInfo.text = "No duplicates were found";
			Log("\rNo duplicates were found");
			//alert("No duplicates were found", scriptName); // debug
			gInterruptMsgs = true;
		}
		else {
			Log("gDupes.length = " + gDupes.length);
			gFoundAll = true;
		}

		var dupsString = Dups2String(gDupes);
		Log(dupsString);
		gInfo.helpTip = dupsString;
		var reportMsg = "==============\rTime elapsed: " + GetDuration(startTime, new Date());
		Log(reportMsg);
//~ 		if (debug) $.writeln(dupsString + "\r" + reportMsg);
		Log("<");
	}
	catch(err) {
		Log(err.message + ", line: " + err.line, true);
		if (debug) {
			$.writeln("ERROR: " + err.message + ", line: " + err.line);
			debugger;
		}
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function CheckSelection() {
	try {
		Log(">");
		//if (debug) var startTime = new Date();
		var msgNoText = "One text frame or some text should be selected" + ((set.ddlStoryText == 0) ? ", or the cursor should be inserted into the text." : ".");
		
		if (app.documents.length == 0) ErrorExit("Please open a document and try again.", true);
		doc = app.activeDocument;
		
		// check if text is selected
		if (app.selection.length == 0 || app.selection.length > 1 ||  // nothing is selected or more than one selection
			(app.selection[0].constructor.name != "TextFrame" && !app.selection[0].hasOwnProperty("baseline"))) // neither text frame nor text
		{
			ErrorExit(msgNoText, true);
		}
		else { // single selection
			var sel = app.selection[0];
			
			if (sel.hasOwnProperty("parentStory")) {
				gStory = sel.parentStory;
				if (gStory == null) ErrorExit("Can't get the selected story.", true);
				Log("gStory.id = " + gStory.id);
				if (set.ddlStoryText == 0) { // selected story
					Log("Processing selected story");
					
					if (gStory.contents == "") { // story is empty
						Log("The selected story is empty.");
						ErrorExit("The selected story is empty.", scriptName, true); // debug
					}
				}
				else if (set.ddlStoryText == 1) { // selected text
					gText = sel;
					if (gText == null) ErrorExit("Can't get the selected text.", true);
					Log("Processing selected text");
					
					if (sel.constructor.name == "InsertionPoint") { // give a warning
						ErrorExit("You chose the 'Selected text' in the dialog box, but instead of selecting the text, you placed the cursor. Select some text and try again.", true);
					}
				}
			} // has parentStory
		} // single selection
	
		//if (debug) Log(GetDuration(startTime, new Date()));
		Log("<");
	}
	catch(err) {
		Log(err.message + ", line: " + err.line, true);
//~ 		$.writeln("ERROR: " + err.message + ", line: " + err.line);
//~ 		debugger;
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function IterateFinds() { // Find / Find Next
	Log(">");
//~ 	if (debug) var startTime = new Date();
	
	var item;

	// you can omit expression 1 (like when your values are set before the loop starts)
	// expression 3 can also be omitted (like when you increment your values inside the loop)
	for ( ; f < gDupes.length; ) {
		item = gDupes[f];
		Log("item = " + item.contents);

		if (gStory != null && gStory.overflows && !gWarningOverset) {
			alert("The text in this story is partially overset. The changes in the overset text may lead to unexpected results.", scriptName); // debug
			gWarningOverset = true;
		}

		try {
			app.select(item, SelectionOptions.replaceWith);
			app.activeWindow.zoom = ZoomOptions.fitPage;
			app.activeWindow.zoomPercentage = set.etZoom;
		}
		catch(err) {
			app.activeWindow.zoomPercentage = 100;
			Log("Error: " + err.message + ", line: " + err.line, true);
//~ 			if (debug) $.writeln(err.message + ", line: " + err.line);
		}

		f++;
		
		if (f == gDupes.length) {
//~ 			Log("f == gDupes.length");
//~ 			Log("Search is completed"); // !!!
			gInfo.text = f + " out of " + gDupes.length + " duplicate" + ((gDupes.length == 1) ? "" : "s.\rThe search is completed.\rClick the 'Reset' button to start again.");
			gBtnFind.text = "Completed.."; 
			gBtnFind.enabled = false;
		}
		else {
			gInfo.text = f + " out of " + gDupes.length + " duplicate" + ((gDupes.length == 1) ? "" : "s");
			gBtnFind.text = "Find Next";
		}
		
//~ 		if (debug) Log(GetDuration(startTime, new Date()));
		Log("<");
		
		return;
	} // end for
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function Dups2String(obj) {
	var o,
	a = [];
	
	for (x in obj) {
		o = obj[x].contents;
		a.push(o);
	}

	return a.toString().replace(",", ", ");
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function TrimLine(line, beg_end) {
	Log(">");
	//if (debug) var startTime = new Date();
	
	var obj = {txt: null, firstCharIdx: null, lastCharIdx: null}; // lastCharIdx not used so far
	// Maybe flat array is faster. I wonder if first/last char makes any difference in performance. Make a speed test later.
	var allChars = line.characters.everyItem().getElements(); 
	var allCharsLength = allChars.length;
	
	obj.firstCharIdx = (set.cbIgnorePunctuation && beg_end == 0) ? GetFirstCharIdx(line) : allChars[0].index;

	if (beg_end == -1) {
		obj.lastCharIdx = GetLastCharIdx(line);
	}
	else {
		obj.lastCharIdx = allChars[allCharsLength - 1].index;
	}

//~ 	obj.txt = line.parentStory.characters.itemByRange(obj.firstCharIdx, obj.lastCharIdx).getElements()[0];
	obj.txt = gStory.characters.itemByRange(obj.firstCharIdx, obj.lastCharIdx).getElements()[0];
	
	//if (debug) Log(GetDuration(startTime, new Date()));
	Log("<");
	
	return obj;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetFirstCharIdx(line) {
	try {
		Log(">");
		Log("gPuncMarksBegPatt = " + decodeURI(gPuncMarksBegPatt));
		
		var lineCont = decodeURI(line.contents); // for debug
		var firstChar = line.characters[0];
		var firstCharCont = firstChar.contents;
		var firstCharIdx = firstChar.index;
		var charCodeString = (firstCharCont.constructor.name == "Enumerator") ? "Enumerator" : CharCodeString(firstCharCont); // for debug
		
		while (firstCharCont.constructor.name == "Enumerator" || firstCharCont.match(gPuncMarksBegPatt) != null) {
			if (debug) {
				charCodeString = (firstCharCont.constructor.name == "Enumerator") ? "Enumerator" : CharCodeString(firstCharCont)
				Log("while loop | firstCharIdx = " + firstCharIdx + " | charCodeString = " + charCodeString + " | firstCharCont = " + firstCharCont);
			}
		
			firstCharIdx++;
			firstChar = gStory.characters[firstCharIdx];
			firstCharCont = firstChar.contents;
		}		

		if (debug) {
			charCodeString = CharCodeString(firstCharCont);
			Log("return: firstCharIdx = " + firstCharIdx + " | charCodeString = " + charCodeString + " | firstCharCont = " + firstCharCont);
	//~ 		Log(GetDuration(startTime, new Date()));
		}		
		
		Log("<");
		return firstCharIdx;
	}
	catch(err) {
		debugger;
		ErrorExit(err.message + ", line: " + err.line, scriptName, true);
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetLastCharIdx(line) {
	try {
		Log(">");
	//~ 	if (debug) var startTime = new Date();
		var lineCont = decodeURI(line.contents); // for debug
		var lastChar = line.characters[-1];
		var lastCharCont = lastChar.contents;
		var lastCharIdx = lastChar.index;
		var charCodeString = (lastCharCont.constructor.name == "Enumerator") ? "Enumerator" : CharCodeString(lastCharCont); // for debug
		
		var patt = (set.cbIgnorePunctuation) ? gPuncMarksEndPatt : (/\s/);
		Log("patt = " + decodeURI(patt));

		while (lastCharCont.constructor.name == "Enumerator" || lastCharCont.match(patt) != null) { // \r matches \s
			if (debug) {
				charCodeString = (lastCharCont.constructor.name == "Enumerator") ? "Enumerator" : CharCodeString(lastCharCont)
				Log("while loop | lastCharIdx = " + lastCharIdx + /*" | charCodeString = " + charCodeString +*/ " | lastCharCont = " + lastCharCont);
			}
		
			lastCharIdx--;
			lastChar = gStory.characters[lastCharIdx];
			lastCharCont = lastChar.contents;
		}

		if (debug) {
			var charCodeString = CharCodeString(lastCharCont);
			Log("return: lastCharIdx = " + lastCharIdx + /*" | charCodeString = " + charCodeString +*/ " | lastCharCont = " + lastCharCont);
	//~ 		Log(GetDuration(startTime, new Date()));
		}

		Log("<");
		return lastCharIdx;
	}
	catch(err) {
		ErrorExit(err.message + ", line: " + err.line, scriptName, true);
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function CheckHyphenated(lineThis) {
	try {
		//Log(">");
		//if (debug) var startTime = new Date();
		
		var result = false
		lastWord = null;
		
		if (lineThis != null) {
			lastWord = lineThis.words[-1];
			
			if (lastWord != null && lastWord.lines.length == 2) {
				result = true;
			}
		}

		//Log("result = " + result);
		//if (debug) Log(GetDuration(startTime, new Date()));
		//Log("<");
		
		return result;
	}
	catch(err) {
		Log(err.message + ", line: " + err.line, true);
		if (debug) {
			$.writeln("ERROR: " + err.message + ", line: " + err.line);
			debugger;
		}
	}
}
//=======================================================================================
function CreateDialog() {
	Log(">");
	GetDialogSettings();
	w = new Window("palette", scriptName.replace(/\-\s\d+\.\d+$/, "")); // global | remove ver number from dialog
	if (set.dlgLocation != null) {
		w.location = set.dlgLocation;
	}
	w.onClose = function() {
		try {
			set.dlgLocation = String(w.location);
			set.ddlBegEnd = ddlBegEnd.selection.index;
			set.ddlWordChar = ddlWordChar.selection.index;
			set.ddlStoryText = ddlStoryText.selection.index;
			set.etZoom = etZoom.text;
			set.cbIgnoreCase = cbIgnoreCase.value;
			set.cbIgnorePunctuation = cbIgnorePunctuation.value;
			app.insertLabel("Kas_" + scriptName, set.toSource());
		}
		catch(err) {
			ErrorExit(err.message + ", line: " + err.line, scriptName, true);
		}
	}
	
	var pnlSettings = w.add("panel", undefined, "Settings:");
	pnlSettings.orientation = "column";
	pnlSettings.alignment = "fill";
	pnlSettings.alignChildren = "right";
	
	// Beginning / End / Both
	var ddlBegEnd = pnlSettings.add("dropdownlist", undefined, ["Beginning", "End"]);
	ddlBegEnd.helpTip = "Location on the line: Beginning or End";
	ddlBegEnd.selection = set.ddlBegEnd;
	ddlBegEnd.alignment = "fill";
	ddlBegEnd.onChange = function() {
		set.ddlBegEnd = this.selection.index;
		Log("ddlBegEnd.onChange - set.ddlBegEnd = " + set.ddlBegEnd);
		Reset();
	}

	// Mode
	var ddlWordChar = pnlSettings.add("dropdownlist", undefined, ["Word", "Character"]);
	ddlWordChar.helpTip = "What to find: Word or Character";
	ddlWordChar.selection = set.ddlWordChar;
	ddlWordChar.alignment = "fill";
	ddlWordChar.onChange = function() {
		set.ddlWordChar = this.selection.index;
		Log("ddlWordChar.onChange - set.ddlWordChar = " + set.ddlWordChar);
		Reset();
	}

	// Story / Text
	var ddlStoryText = pnlSettings.add("dropdownlist", undefined, ["Story", "Text"]);
	ddlStoryText.helpTip = "What should be processed: selected story or text?";
	ddlStoryText.selection = set.ddlStoryText;
	ddlStoryText.alignment = "fill";
	ddlStoryText.onChange = function() {
		if (this.selection.index == 0) {
			set.ddlStoryText = 0;
			Reset();
		}
		else if (this.selection.index == 1) {
			set.ddlStoryText = 1;
			Reset();
		}
	}

	// Zoom
	var grZoom = pnlSettings.add("group");
	grZoom.orientation = "row";

	var iconBinReset = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x14\x00\x00\x00\x14\b\x06\x00\x00\x00\u008D\u0089\x1D\r\x00\x00\x00\tpHYs\x00\x00\x0B\x13\x00\x00\x0B\x13\x01\x00\u009A\u009C\x18\x00\x00\x06\u00BEiTXtXML:com.adobe.xmp\x00\x00\x00\x00\x00<?xpacket begin=\"\u00EF\u00BB\u00BF\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?> <x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 7.1-c000 79.a8731b9, 2021/09/09-00:37:38        \"> <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"> <rdf:Description rdf:about=\"\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:photoshop=\"http://ns.adobe.com/photoshop/1.0/\" xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\" xmlns:stEvt=\"http://ns.adobe.com/xap/1.0/sType/ResourceEvent#\" xmp:CreatorTool=\"Adobe Photoshop 22.5 (Windows)\" xmp:CreateDate=\"2022-02-17T08:23:36+02:00\" xmp:ModifyDate=\"2022-02-17T10:09:30+02:00\" xmp:MetadataDate=\"2022-02-17T10:09:30+02:00\" dc:format=\"image/png\" photoshop:ColorMode=\"3\" photoshop:ICCProfile=\"Adobe RGB (1998)\" xmpMM:InstanceID=\"xmp.iid:544ee920-4cda-6646-baa6-7edb9c0e5021\" xmpMM:DocumentID=\"adobe:docid:photoshop:c8774ef7-74f4-bc4f-a7c4-a4a0856a35a5\" xmpMM:OriginalDocumentID=\"xmp.did:1f6f5141-8461-414e-b95e-279858268f8e\"> <xmpMM:History> <rdf:Seq> <rdf:li stEvt:action=\"created\" stEvt:instanceID=\"xmp.iid:1f6f5141-8461-414e-b95e-279858268f8e\" stEvt:when=\"2022-02-17T08:23:36+02:00\" stEvt:softwareAgent=\"Adobe Photoshop 22.5 (Windows)\"/> <rdf:li stEvt:action=\"saved\" stEvt:instanceID=\"xmp.iid:d5ee5de3-dcd2-5944-9c5f-ceb7280a29eb\" stEvt:when=\"2022-02-17T10:08:12+02:00\" stEvt:softwareAgent=\"Adobe Photoshop 22.5 (Windows)\" stEvt:changed=\"/\"/> <rdf:li stEvt:action=\"saved\" stEvt:instanceID=\"xmp.iid:544ee920-4cda-6646-baa6-7edb9c0e5021\" stEvt:when=\"2022-02-17T10:09:30+02:00\" stEvt:softwareAgent=\"Adobe Photoshop 22.5 (Windows)\" stEvt:changed=\"/\"/> </rdf:Seq> </xmpMM:History> </rdf:Description> </rdf:RDF> </x:xmpmeta> <?xpacket end=\"r\"?>\u00EF\u009A\u0097B\x00\x00\x01.IDAT8\x11\u00AD\u00C1?nR\x01\x00\x07\u00E0/\u00C2\u00F3\x06N\f/u\x11\u00E8\t:9y\x01;iIpw\u00F0\x06\u00AE\u00A6\u00A6\x7F\u0088\u009B^\u00C0\u008Dn\x1A=\u00C2s\x11\u00B9\x05\x18:\u00B4I\x13\u0097\u009F\u008FHb\u00D3?\x01J\u00BF\u00CF-\x1E\u00E2\x15Np\u008E 8\u00C7\t\u00FA(\u00FC\u00F7\foQ\u00B8A\x0FS\x04\u00C1\x04\x15*L\x11\x04\x13\u00EC\u00F9\u00E73\u0082\u00B6+\x0E\x11\x04\u00EF\u00D0q]\x17\u00FB\b\u0082\u00D7\u00F8\u0088`\u00DB%\x1F\x10\u00FC\u00C4\x13\u00CB51D\u00F0\x07A\u00C7\u00C2.\u0082_hX\u00EE)>\u00E1\x0B\u0082 \u00D8Vk\u00E0\x14A\u00CBj\u00DE \b\u0082 \u00E8\u00A8\u00F5\x10\x1CZO\u0089\x12%J\u0094(\u00D4\u00BE#\u00D8rO.0s\u008F\u0082\u00CA\u0086\u0092Hb.\u00F8aCI$1w\u0081\u0099\u00CD=\u00C2\u008E\u00DA7\x04[\u00EE\u00EE1\u0082\u00AFj=\x04G\u00EE\u00EE\x18\u00C1K\u00B5\x06N\x11\u00B4\u00AC\u00AF\u0085`\u0086\x07\x16v\x11\u008C\u00D1\u00B4\u00BA&\u00C6\b\u009E\u00BBb\u0080`\u0084\u00B6\u00E5\u00DA\x18!\x18\u00B8\u00C5\x01\u0082`\x1F]\u00D7u\u00F1\x1EAp`\u0089=L\x10\x04ST\u00A8\u00F0\x1BA0\u00C1\x0B+*\u00D0\u00C7\x10g\b\u00823\f\u00D1G\u00E1\x06\x7F\x01\u00F8-r\u00F4G\x7F\x05t\x00\x00\x00\x00IEND\u00AEB`\u0082";
	var iconReset = IconMaker(iconBinReset, gTmpSubFolderName, gTmpFileName + "_icon_reset"); // iconBin, tmpSubFolderName, imgFileName
	var btnReset = grZoom.add("iconbutton", undefined, iconReset);
	btnReset.preferredSize = [20, 20];
	btnReset.helpTip = "Reset settings";
	btnReset.onClick = function() {
//~ 		if (debug) $.writeln("Reset");
		Reset(true, true); // resetSel, resetInfo
	}

	var stZoom = grZoom.add("statictext", undefined, "Zoom:");
	var etZoom = grZoom.add("edittext", undefined, set.etZoom);
	etZoom.characters = 3;
	etZoom.onChange = function() {
		Log("etZoom.onChange");
		if (this.text == "") {
			alert("The \"Zoom\" text field should not be empty.", "Error", true); // debug
			this.text = String(set.etZoom);
		}
		else if (isNaN(this.text)) {
			alert("\"Zoom\" should be a number.", "Error", true); // debug
			this.text = String(set.etZoom);
		}
		else {
			set.etZoom = Number(this.text);
			Log("set.etZoom = " + set.etZoom);
		}
	}
	stZoom.helpTip = etZoom.helpTip = "Zoom level for the found text";
	
	var cbIgnoreCase = pnlSettings.add("checkbox", undefined, "Ignore case");
	cbIgnoreCase.value = set.cbIgnoreCase;
	cbIgnoreCase.alignment = "left";
	cbIgnoreCase.onClick = function() {
		set.cbIgnoreCase = this.value;
		Reset();
	}

	var cbIgnorePunctuation = pnlSettings.add("checkbox", undefined, "Ignore punctuation");
	cbIgnorePunctuation.value = set.cbIgnorePunctuation;
	cbIgnorePunctuation.alignment = "left";
	cbIgnorePunctuation.onClick = function() {
		set.cbIgnorePunctuation = this.value;
		Reset();
	}

	var pnlInfo = w.add("panel", undefined, "Info:");
	pnlInfo.orientation = "column";
	pnlInfo.alignment = "fill";
	pnlInfo.alignChildren = "left";

	gInfo = pnlInfo.add("statictext", undefined, gInitInfoMsg, {multiline: true});
	gInfo.preferredSize = [110, 60];
	gInfo.helpTip = "Click 'Find' to start finding duplicates";
	
	// Buttons
	var pnlButtons = w.add("panel", undefined, "");
	pnlButtons.orientation = "column";
	pnlButtons.alignment = "fill";
	
	var buttonWidth = 100;
	gBtnFind = pnlButtons.add("button", undefined, "Find");
	gBtnFind.preferredSize.width = buttonWidth;
	gBtnFind.onClick = function() {
		Log("gBtnFind.onClick");
		
		if (!gFoundAll) {
			FindAll();
			
			if (!gInterruptMsgs) {
				IterateFinds();
			}
			else {
				Reset();
			}
		} 
		else {
			IterateFinds();
		}
	}
	
	var btnClose = pnlButtons.add("button", undefined, "Close");
	btnClose.preferredSize.width = buttonWidth;
	btnClose.onClick = function() {
		Log("Closing window");
		w.close();
	}

	var btnAbout = pnlButtons.add("button", undefined, "About");
	btnAbout.preferredSize.width = buttonWidth;
	btnAbout.onClick = function() {
		JumpToLink(gTmpSubFolderName, gTmpFileName + "_temp", gUrl); // tmpSubFolderName, tmpFileName, url
	}

	w.show();
	Log("Showing window");
	Log("<");
}	
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetDialogSettings() {
	Log(">");
	set = eval(app.extractLabel("Kas_" + scriptName));
	if (set == undefined) {
		Log("Loading defaults");
		set = {dlgLocation: null, etZoom: 100, cbIgnoreCase: false, cbIgnorePunctuation: true, ddlBegEnd: 0, ddlWordChar: 0, ddlStoryText: 0};
	}

	if (set.dlgLocation != null) {
		set.dlgLocation = set.dlgLocation.split(","); // beg_end is array of numbers
		set.dlgLocation[0] = Number(set.dlgLocation[0]);
		set.dlgLocation[1] = Number(set.dlgLocation[1]);
	}

	set.etZoom = Number(set.etZoom);

	if (isNaN(set.etZoom) || set.etZoom == 0) { // if something goes, wrong reset to 100%
		set.etZoom = 100;
	}
	
	if (debug) var tmp = set;
	
	with (set) {
		Log("ddlBegEnd = " + ddlBegEnd + 
			", ddlWordChar = " + ddlWordChar + 
			", ddlStoryText = " + ddlStoryText + 
			", etZoom = " + etZoom + 
			", cbIgnoreCase = " + cbIgnoreCase + 
			", cbIgnorePunctuation = " + cbIgnorePunctuation + 
			", dlgLocation = " + ((dlgLocation == null) ? "null" : "[" + dlgLocation.toString() + "]")
		);
	}

	Log("<");
	
	return set;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function Reset(resetSel, resetInfo) { // reset global variables
	Log(">");
//~ 	$.writeln("Reset");
	
	if (typeof resetSel == "undefined") resetSel = false;
	if (resetSel) app.selection = NothingEnum.NOTHING;	
	if (typeof resetInfo == "undefined") resetInfo = false;
	if (resetInfo) gInfo.text = gInitInfoMsg;
	
	doc = gText = null;
	f = 0;
	gDupes = [];
	gFoundAll = gWarningOverset = gInterruptMsgs = false;

	try {
		if (gBtnFind != null) { //  && typeof gBtnFind != "undefined"
			gBtnFind.text = "Find";
			gBtnFind.enabled = true;
		}
		Log("<");
	}
	catch(err) {
		Log("Error: " + err.message + ", line: " + err.line, true);
//~ 		if (debug) $.writeln(err.message + ", line: " + err.line);
		gBtnFind = null;
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function ErrorExit(error, icon) {
	alert(error, scriptName, icon); // debug
	exit();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function IconMaker(iconBin, tmpSubFolderName, imgFileName) {
	var iconFile = null;
	var tmpFolderPath = Folder.temp.absoluteURI + "/" + tmpSubFolderName +"/";
	var tmpFolder = new Folder(tmpFolderPath);
	if (!tmpFolder.exists) tmpFolder.create();
	iconFile = new File(tmpFolderPath + imgFileName + ".png");
	
	if (!iconFile.exists) {
		iconFile.encoding = "BINARY";
		iconFile.open("w");
		iconFile.write(iconBin);
		iconFile.close();
	}

	return iconFile;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function JumpToLink(tmpSubFolderName, tmpFileName, url) {
	var tmpFolder = new Folder(Folder.temp.absoluteURI + "/" + tmpSubFolderName);
	if (!tmpFolder.exists) tmpFolder.create();
	if (tmpFileName.match(/\.htm(l)*$/) == null) {
		tmpFileName += ".html"
	}
	var linkJumper = File(tmpFolder.absoluteURI + "/" + tmpFileName);
	
	if (!linkJumper.exists) {
		linkJumper.open("w");
		var linkBody = '<html><head><META HTTP-EQUIV=Refresh CONTENT="0; URL=' + url + '"></head><body> <p></body></html>'
		linkJumper.write(linkBody);
		linkJumper.close();
	}

	linkJumper.execute();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetDuration(startTime, endTime) {
	var str;
	var duration = (endTime - startTime)/1000;
	duration = Math.round(duration);
	if (duration >= 60) {
		var minutes = Math.floor(duration/60);
		var seconds = duration - (minutes * 60);
		str = minutes + ((minutes != 1) ? " minutes, " :  " minute, ") + seconds + ((seconds != 1) ? " seconds" : " second");
		if (minutes >= 60) {
			var hours = Math.floor(minutes/60);
			minutes = minutes - (hours * 60);
			str = hours + ((hours != 1) ? " hours, " : " hour, ") + minutes + ((minutes != 1) ? " minutes, " :  " minute, ") + seconds + ((seconds != 1) ? " seconds" : " second");
		}
	}
	else {
		str = duration + ((duration != 1) ? " seconds" : " second");
	}

	return str;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function ZeroPad(num, digit) {
	var tmp = num.toString();
	while (tmp.length < digit) {
		tmp = "0" + tmp;
	}
	return tmp;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function Log(text, err) {
	var header = null;
	
	var debugFunc = function (string) {
		for (var x in logDebugFuncList) {
			if (string == logDebugFuncList[x]) {
				return true;
			}
		}
		return false;
	}

	var callerName = function () {
		var arr = $.stack.split(/[\n]/),  
		caller = arr[arr.length - 3].replace(/\(.*\)/, "");
		return caller;  
	}

	if (log) { // log - everything | not in the list & not error | only errors & this is error
		var curFunc = callerName();
		
		if ((logErrOnly && err) || (!logErrOnly && !logDebugListOnly) || (!logErrOnly && logDebugListOnly && debugFunc(curFunc))) {
			if (typeof err == "undefined") err = false;
			if (typeof logOverwrite == "undefined") logOverwrite = false;
			var path = "~/Desktop/" + scriptName + " - ";
			var logFullFile = new File(path + "Log.txt");
			var logErrFile = new File(path + "Error Log.txt");

			if (logOverwrite) { // Remove existing files
				if (err) { // Error
					if (logErrFile.exists && logErrCount == 0) {
						logErrFile.remove();
					}
				}
				else { // Full
					if (logFullFile.exists && logFullCount == 0) {
						logFullFile.remove();
					}						
				}
			}

			if ((!err && logFullCount == 0) || (err && logErrCount == 0)) {
				header = "========== " + new Date().toLocaleString() + " ==========\r" + scriptName + "\r";
				
				if (!logOverwrite) {
					header = "\r" + header;
				}
			}

			if (err) { // Error
				logErrArr.push(text);
				logErrCount++;
				WriteLog(logErrFile, "ERROR: " + text, header, curFunc);
				
				if (!logErrOnly) {
					WriteLog(logFullFile, "ERROR: " + text, ((!logHeaderAdded) ? header : null), curFunc);
				}
			}
			else { // Full
				logFullCount++;

				if (!logHeaderAdded) {
					WriteLog(logFullFile, text, header, curFunc);
					logHeaderAdded = true;
				}
				else {
					WriteLog(logFullFile, text, null, curFunc);
				}
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function WriteLog(file, text, header, curFunc) {
	file.encoding = "UTF-8";

	if (file.exists) {
		file.open("e");
		file.seek(0, 2);
	}
	else {
		file.open("w");
	}

	if (header != null) {
		file.write(header);
	}

	if (text == ">") {
		file.write("\r===>> " + curFunc + " ===\r");
	}
	else if (text == "<") {
		file.write("=== " + curFunc + " ===>>\r\r");
	}
	else {
		file.write(text + "\r");
	}
	
	file.close();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function VisualiseSpaces(txt) { // for debugging only
	try {
		var str = "",
		contents,
		characters = txt.characters;
		
		for (var i = 0; i < characters.length; i++) {
			contents = characters[i].contents;
			
			if ("" + contents.constructor.name == "Enumerator") {
				if (contents == SpecialCharacters.FORCED_LINE_BREAK) {
					str += "\\n";
				}
				else {
					str += "{" + contents.toString().toLowerCase().replace(/_/g, " ") + "}";
				}
			}
			else {
				str += contents.replace(/\t/g, "\\t").replace(/\r/g, "\\r").replace(/ /g, "◊");
			}
		} 

		return str;
	}
	catch(err) {
		ErrorExit(err.message + ", line: " + err.line, scriptName, true);
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function CharCodeString(str) { // for debugging only
	try {
		var s = "";
		//debugger;		
		for (var i = 0; i < str.length; i++) {
			s += ((i != 0) ? "|" : "") + str.charCodeAt(i);
		}

		return s;
	}
	catch(err) {
		debugger;
		ErrorExit(err.message + ", line: " + err.line, scriptName, true);
		return null;
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function CleanText(text) {
	try {	
		var txt = text.replace(/\uFEFF/g, "").replace(/\uFFFC/g, "").replace(/\u00AD/g, ""); // 65279 = FEFF hyperlink anchor, index marker, 65532 = FFFC anchored object, (ctrl+ shift+dash)

		if (set.cbIgnorePunctuation && set.ddlWordChar == 0) {
			if (set.ddlBegEnd == 0) {
				txt = txt.replace(gPuncMarksBegPatt, "");
			}
			else if (set.ddlBegEnd == 1) {
				txt = txt.replace(gPuncMarksEndPatt, "");
			}
		}

		txt = txt.replace(/^\s+|\s+$/g, ""); // Remove spaces at the end and beginning

		if (set.cbIgnoreCase) txt = txt.toLowerCase();
		return txt;
	}
	catch(err) {
		debugger;
		ErrorExit(err.message + ", line: " + err.line, scriptName, true);
		return null;
	}	
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
/*

*/